using System; 
 using System.Collections.Generic; 
 using System.ComponentModel; using System.Data; 
 using System.Drawing; 
 using System.Linq; 
 using System.Text; using System.Windows.Forms; 
 using PsgBase;
using PsgIntl;

namespace Suppliers
{
    [EditorClass, ViewGrid]
    public partial class Suppliers : Base
    {
        #region Global variables
        SuppliersBE.SuppliersDataTable table = new SuppliersBE.SuppliersDataTable();
        SuppliersBE.SuppliersRow rowA = null;
        #endregion

        #region Constructors

        public Suppliers()
        {
            InitializeComponent();
        }

        public Suppliers(ViewGrid _view)
            : base(_view)
        {
            InitializeComponent();
        }

        public Suppliers(LookupGrid _lookup)
            : base(_lookup)
        {
            InitializeComponent();
            this.lookup = _lookup;
            this.TypeList = TypeListInfo.LookupGrid;
        }

        #endregion Constructors

        #region Base

        public override void PsgContext(IContext context)
        {
            base.PsgContext(context);

            context.PsgFieldKey = "supplierid";
            context.PsgFieldDisplay = "companyname";
            context.PsgCommand = "suppliers";
            context.PsgServerTableName = "suppliers";
        }

        public override void PsgStart()
        {
            base.PsgStart();
            AddTable("suppliers", ID, "C");
            GetTables(this);
        }

        public override void PsgData(DataTable dt)
        {
            base.PsgData(table);
            switch (this.alias_name.ToUpper())
            {
                case "SUPPLIERS":
                    table = (SuppliersBE.SuppliersDataTable)SetMainData(dt, table);
                    rowA = (SuppliersBE.SuppliersRow)table.Rows[0];
                    break;
            }
        }

        public override void PsgBind()
        {
            BindEdit(edCompanyName, table.CompanyNameColumn);
            BindEdit(edContactName, table.ContactNameColumn);
            BindEdit(edContactTitle, table.ContactTitleColumn);
            BindEdit(edAddress, table.AddressColumn);
            BindEdit(edCity, table.CityColumn);
            BindEdit(edRegion, table.RegionColumn);
            BindEdit(edPostalCode, table.PostalCodeColumn);
            BindEdit(edCountry, table.CountryColumn);
            BindEdit(edPhone, table.PhoneColumn);
            BindEdit(edFax, table.FaxColumn);
            BindEdit(edHomePage, table.HomePageColumn);

            base.PsgBind();
        }

        public override void PsgView()
        {
            base.PsgView();

            this.ColumnsView(table.CompanyNameColumn, GetIntl(Intl.Supplier), 200);
            this.ColumnsView(table.ContactNameColumn, GetIntl(Intl.Contact_name), 150);
            this.ColumnsView(table.ContactTitleColumn, GetIntl(Intl.Contact_title), 150);
            this.ColumnsView(table.AddressColumn, GetIntl(Intl.Address), 150);
            this.ColumnsView(table.CityColumn, GetIntl(Intl.City));
            this.ColumnsView(table.RegionColumn, GetIntl(Intl.Region));
            this.ColumnsView(table.PostalCodeColumn, GetIntl(Intl.Postal_Code));
            this.ColumnsView(table.CountryColumn, GetIntl(Intl.Country));
            this.ColumnsView(table.PhoneColumn, GetIntl(Intl.Phone_numbers));
            this.ColumnsView(table.FaxColumn, GetIntl(Intl.Fax));
            this.ColumnsView(table.HomePageColumn, GetIntl(Intl.Homepage));

            this.FiltersView(table.CompanyNameColumn, GetIntl(Intl.Supplier));
            this.FiltersView(table.ContactNameColumn, GetIntl(Intl.Contact_name));
            this.FiltersView(table.ContactTitleColumn, GetIntl(Intl.Contact_title));
            this.FiltersView(table.AddressColumn, GetIntl(Intl.Address));
            this.FiltersView(table.CityColumn, GetIntl(Intl.City));
            this.FiltersView(table.RegionColumn, GetIntl(Intl.Region));
            this.FiltersView(table.PostalCodeColumn, GetIntl(Intl.Postal_Code));
            this.FiltersView(table.CountryColumn, GetIntl(Intl.Country));
            this.FiltersView(table.PhoneColumn, GetIntl(Intl.Phone_numbers));
            this.FiltersView(table.FaxColumn, GetIntl(Intl.Fax));
            this.FiltersView(table.HomePageColumn, GetIntl(Intl.Homepage));
        }

        #endregion
    }
}